*================================================================*
* SAS programmer: James Nguyen, USEPA                            *
*                                                                *
* Project: OP inhibition studies                                 *
*                                                                *
* Chemical: Omethoate                                             *
*                                                                *
* Descriptions:                                                  *
*     - run the selected (Exponent) final models                 *
*     - perform regression diagnostics                           *
*     - calculated ki values from human vs. rat analysis         *
*                                                                *
* Date: March 2020                                               *
*===============================================================*;
option formdlim="=" ls=100 ps=100 nodate nonumber;

%include "C:\Users\JNguyen\OneDrive - Environmental Protection Agency (EPA)\Animal studies\50773501-2-3 In Vitro Inhibition Study\from James\SAS code Final Models\Diagnostics.SAS";

libname EPA "C:\Users\JNguyen\OneDrive - Environmental Protection Agency (EPA)\Animal studies\50773501-2-3 In Vitro Inhibition Study\from James\kapp data";
/****************************************************************************/
/* Final NLMIXED Model                                                      */
/****************************************************************************/
data omethoate_avg;
     set epa.omethoate_avg;
run;
proc sort data=omethoate_avg;
     by id;
run;

ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\Omethoate - individual sample curves.rtf" startpage=no;
%scatter_plot(chemical=Omethoate_avg);
ods rtf close;


*==> Human vs. rat;

title "Human vs. rat: final model 2b";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm;
PROC NLMIXED data=OMETHOATE_avg  tech=newrap lis=3;
      PARMS ha=.4262		hb=.7008
			ra=0.8932		rb=.3832
			ga=0.3615	
			gab=1.5648	
			gb=.7103
			S2E=0.2928/best=1000;

            rha=ha+ua;
			rra=ra+ua;
            rhb=hb+ub;
			rrb=rb+ub;
            PRED = (rha*H_I__M + rra*R_I__M)/(rhb*Human*1e-3 + H_I__M + rrb*Rat*1e-3 + R_I__M);
      MODEL KAPP ~ NORMAL(PRED, S2E*1e-3);
      RANDOM  ua ub ~ normal([0, 0],  [ga*1e-1, gab*1e-2, gb*1e-1]) SUBJECT=ID out=RandID_HR; 
	  ESTIMATE "human/rat" (ha/hb)/(ra/rb);
	  ESTIMATE 'human ki' (ha/hb);
      ESTIMATE 'rat ki' (ra/rb);
	  predict pred out=Resid_HR;
run;


ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\Omethoate human-rat.rtf" startpage=no;
%DiagnosticsHR(chemical=Omethoate, model=2)
ods rtf close;
%Calculate_Ki(chemical=Omethoate, Hadj=1e-3, Radj=1e-3);



*==> Adult vs. Infant;


*===> model 2 below is probably better (no WARNINGs), but it was not selected by Exponent;

title "Adult vs. Infant: model 2";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm;
PROC NLMIXED data=omethoate_avg(where=(Human=1))  tech=nrridg lis=3 maxiter=1000 method=firo;
      PARMS ada=.36	adB=.47
			ia=.51 iB=.91
			gha=0.38	ghab=0.36 	ghb=0.12
			S2E=0.1678;
			rada=ada+uha;
			ria=ia+uha;
            radb=adB+uhb;
			rib=iB+uhb;
            PRED = (rada*H_I__M*adult + ria*H_I__M*infant)/(radb*adult*1e-3 + H_I__M*adult + rib*infant*1e-3 + H_I__M*infant);
      MODEL KAPP ~ NORMAL(PRED, S2E*1e-3);
      RANDOM  uha uhb ~ normal([0, 0],  [gha*1e-1, ghab*1e-1, ghb]) SUBJECT=ID out=RandID_AI; 
	 ESTIMATE "Adult/Infant ki" (ada/adb)/(ia/ib);
	  ESTIMATE 'Adult ki' (ada/adb);
      ESTIMATE 'Infant ki' (ia/ib);
	  predict pred out=Resid_AI;
run;

ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\Omethoate Adult-Infant (correct model).rtf" startpage=no;
%DiagnosticsAI(chemical=Omethoate, model=2);
ods rtf close;


/*

title "Model 3 - Adult (>=10 yr) vs. Infant (Exponent model)";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm;
PROC NLMIXED data=omethoate_avg(where=(Human=1))  tech=nrridg lis=3 maxiter=1000 method=firo;
      PARMS ada=.37 adB=.49
			ia=.46 iB=.75
			gada=.40	gadab=.31	gadb=.14
			gia=.45 	giab=.78 	gib=.16
			S2E=.1657;

          	rada=ada+uada;
			radb=adB+uadb;
			ria=ia+uia;
           	rib=iB+uib;
            PRED = (rada*H_I__M*adult + ria*H_I__M*infant)/(radb*adult*1e-3 + H_I__M*adult + rib*1e-3*infant + H_I__M*infant);
      MODEL KAPP ~ NORMAL(PRED, S2E*1e-3);
      RANDOM  uada uadb uia uib ~ normal([0, 0, 0, 0],   [gada*1e-1, 
														gadab*1e-1, gadb, 
														0,    0,     gia*1e-1, 
														0,    0,     giab*1e-1,   gib]) SUBJECT=ID out=RandID_AI; 
	 ESTIMATE "Adult/Infant ki" (ada/adb)/(ia/ib);
	  ESTIMATE 'Adult ki' (ada/adb);
      ESTIMATE 'Infant ki' (ia/ib);
	   predict pred out=Resid_AI;
run;

ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\Omethoate Adult-Infant (Exponent model).rtf" startpage=no;
%DiagnosticsAI(chemical=Omethoate, model=3);
ods rtf close;

*/

*===> Male vs. female;

title "final model 2b - male vs. female";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm;
PROC NLMIXED data=omethoate_avg(where=(Human=1)) method=firo  tech=nrridg lis=3 maxiter=10000;
      PARMS ma=.47 mb= 0.71
			fa=.34 fB=.45
			gha=.45 	ghab=1.88 	ghb=.14
			S2E=.1648;

            rma=ma+uha;
			rfa=fa+uha;
            rmb=mB+uhb;
			rfb=fB+uhb;
            PRED = (rma*H_I__M*male + rfa*H_I__M*female)/(rmb*male*1e-3 + H_I__M*male + rfb*female*1e-3 + H_I__M*female);
      MODEL KAPP ~ NORMAL(PRED, S2E*1e-3);
      RANDOM  uha uhb ~ normal([0, 0],  [gha*1e-1, ghab*1e-2, ghb]) SUBJECT=ID out=RandID_MF; 
	 ESTIMATE "male/female ki" (ma/mb)/(fa/fb);
	  ESTIMATE 'male ki' (ma/mb);
      ESTIMATE 'female ki' (fa/fb);
	  predict pred out=Resid_MF;
run;

ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\Omethoate Male-Female.rtf" startpage=no;
%DiagnosticsMF(chemical=Omethoate, model=2);
ods rtf close;





*===> Caucasian vs. Others;

title "final model 2 - Caucasian vs. Other Race";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm;
PROC NLMIXED data=omethoate_avg(where=(Human=1))  tech=newrap lis=3 method=firo maxiter=10000;
      PARMS ca=.38	cB=.48
			ora=.39 orB=.70
			gha=.37 	ghab=.33 	ghb=.14
			S2E=.1636;

            rca=ca+uha;
			rora=ora+uha;
            rcb=cB+uhb;
			rorb=orB+uhb;
		PRED = (rca*H_I__M*caucasian + rora*H_I__M*otherrace)/(rcb*caucasian*1e-3 + H_I__M*caucasian + rorb*otherrace*1e-3 + H_I__M*otherrace);
      MODEL KAPP ~ NORMAL(PRED, S2E*1e-3);
      RANDOM  uha uhb ~ normal([0, 0],  [gha*1e-1, ghab*1e-1, ghb]) SUBJECT=ID out=RandID_CO; 
	 ESTIMATE "Caucasian/Other Race ki" (ca/cb)/(ora/orb);
	  ESTIMATE 'Caucasian ki' (ca/cb);
      ESTIMATE 'Other Race ki' (ora/orb);
	  predict pred out=Resid_CO;
run;

ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\Omethoate Caucasian-Other Races.rtf" startpage=no;
%DiagnosticsCO(chemical=Omethoate, model=2);
ods rtf close;
